## this script randomizes two pads and then picks at random samples from libraries
## beginning with 'ambi', 'drum', and 'perc'

with_fx(:reverb, room: 1.0, mix: 1.0, mix_slide: 0.1, damp: 0.5, damp_slide: 1) do |r_fx|
  live_loop :hum do
    mix = rrand(0.5, 1.0)
    use_random_seed 300
    sample :vinyl_backspin, cutoff: rrand(80,100), amp: rand+0.01, beat_stretch: 16
    32.times{ sleep 1; control r_fx, damp: rand, mix: [1.0, mix+0.01].min}
  end
end

with_fx(:reverb) do
  live_loop :dark do
    with_fx(:echo, room: 1.0, mix: 0.8, decay: 8.0, reps: 4) do
      n = scale(:G3, :minor_pentatonic, num_octaves: 3).take(3).shuffle
      16.times{
        with_transpose(-24) do
          synth :hollow, note: n.choose, decay: 4, attack: 4.0, amp: 0.5
        end
        sleep 8
        synth :dark_ambience, note: n.choose, decay: 4, attack: 4.0, amp: 0.5,
        cutoff: 120, detune1: 6, detune2: 12
        sleep 8
      }
    end
  end
end

load_samples(sample_names :ambi)
sleep 2

with_fx :reverb, mix: 0.8 do
  live_loop :picker do
    sp_name = choose sample_names :ambi
    sp_name = choose sample_names :drum
    sp_name = choose sample_names :perc
    sp_time = [1, 7].choose
    sp_time = rrand(2,8)
    sp_rate = rrand(-3,3)
    sp_rate = 4

    s = sample sp_name, cutoff: rrand(70, 130), rate: sp_rate * choose([0.5, 1]), pan: rrand(-1, 1), pan_slide: sp_time
    control s, pan: rrand(-1, 1)
    sleep sp_time
  end
end
